<Query Kind="Program" />

void Main()
{
	var foo = new Foo();
	
	// Test bez wywoływania SuspendEvents()
	foo.FireSomeEvent(); 
	
	// Now test it with event suspension:
	using (foo.SuspendEvents())
	{
		foo.FireSomeEvent();
	}

	// Znowu test bez wywoływania SuspendEvents()
	foo.FireSomeEvent();

}

class Foo
{
	int _suspendCount;

	public IDisposable SuspendEvents()
	{
		_suspendCount++;
		return Disposable.Create (() => _suspendCount--);
	}

	public void FireSomeEvent()
	{
		if (_suspendCount == 0) 
			"Zdarzenie zostałoby zgłoszone".Dump();
		else
			"Zdarzenie stłumione".Dump();
	}
}

// Klasa do wielokrotnego użytku
public class Disposable : IDisposable
{
	public static Disposable Create (Action onDispose)
		=> new Disposable (onDispose);

	Action _onDispose;
	Disposable (Action onDispose) => _onDispose = onDispose;

	public void Dispose()
	{
		_onDispose?.Invoke();
		_onDispose = null;
	}
}